import 'package:flutter/material.dart';
import 'package:flutter/services.dart';
import 'package:get/get.dart';
import 'package:viser_remit/core/helper/date_converter.dart';
import 'package:viser_remit/core/helper/string_format_helper.dart';
import 'package:viser_remit/data/controller/transection/transection_controller.dart';
import 'package:viser_remit/data/services/api_client.dart';
import 'package:viser_remit/view/components/bottom-sheet/bottom_sheet_header_row.dart';
import 'package:viser_remit/view/components/divider/custom_divider.dart';
import 'package:viser_remit/view/components/snack_bar/show_custom_snackbar.dart';

import '../../../../core/utils/dimensions.dart';
import '../../../../core/utils/my_color.dart';
import '../../../../core/utils/my_strings.dart';
import '../../../../core/utils/style.dart';
import 'package:viser_remit/data/model/transection_history/transaction_history_response_model.dart';

class TransectionDetailsBottomSheet extends StatelessWidget {
  final TransactionController controller;
  final Data transactionData;

  const TransectionDetailsBottomSheet({super.key, required this.controller, required this.transactionData});

  @override
  Widget build(BuildContext context) {
    return Column(
      children: [
        const BottomSheetHeaderRow(isShowCloseButton: false),
        Row(
          children: [
            Expanded(
                child: Text(
              MyStrings.trxNumber.tr,
              style: mediumLarge,
            )),
            Expanded(
                child: Row(
              mainAxisAlignment: MainAxisAlignment.spaceBetween,
              children: [
                const SizedBox(),
                Flexible(
                  child: GestureDetector(
                      onTap: () async {
                        await Clipboard.setData(ClipboardData(text: "${transactionData.trx}"));
                        CustomSnackBar.success(successList: [MyStrings.copied]);
                      },
                      child: Text("#${transactionData.trx}", style: mediumLarge)),
                ),
              ],
            ))
          ],
        ),
        const CustomDivider(),
        Row(
          children: [
            Expanded(child: Text(MyStrings.amount.tr, style: mediumLarge)),
            Expanded(
              child: Column(
                crossAxisAlignment: CrossAxisAlignment.end,
                children: [
                  Text(
                    "${Converter.formatNumber(transactionData.amount.toString())} ${Get.find<ApiClient>().getCurrencyOrUsername(isCurrency: true)}",
                    style: mediumLarge,
                  ),
                  const SizedBox(height: Dimensions.space4),
                  Text(
                    "${MyStrings.charge}: ${Converter.formatNumber(transactionData.charge.toString())} ${Get.find<ApiClient>().getCurrencyOrUsername(isCurrency: true)}",
                    style: mediumDefault.copyWith(color: MyColor.colorRed),
                  )
                ],
              ),
            )
          ],
        ),
        const CustomDivider(),
        Row(
          mainAxisAlignment: MainAxisAlignment.spaceBetween,
          children: [
            Expanded(child: Text(MyStrings.postBalance.tr, style: mediumLarge)),
            Expanded(
                child: Row(
              mainAxisAlignment: MainAxisAlignment.spaceBetween,
              children: [
                const SizedBox(),
                Flexible(
                  child: Text(Converter.formatNumber(transactionData.postBalance.toString()), overflow: TextOverflow.ellipsis, style: mediumLarge),
                ),
              ],
            ))
          ],
        ),
        const CustomDivider(),
        Row(
          children: [
            Expanded(child: Text(MyStrings.details.tr, style: mediumLarge)),
            Expanded(
                child: Row(
              mainAxisAlignment: MainAxisAlignment.spaceBetween,
              children: [
                const SizedBox(),
                Flexible(
                  child: Text(transactionData.details.toString(), style: mediumLarge),
                ),
              ],
            ))
          ],
        ),
        const CustomDivider(),
        Row(
          children: [
            Expanded(child: Text(MyStrings.time.tr, style: mediumLarge)),
            Expanded(
                child: Row(
              mainAxisAlignment: MainAxisAlignment.spaceBetween,
              children: [
                const SizedBox(),
                Flexible(
                  child: Text(DateConverter.isoStringToLocalDateOnly(transactionData.createdAt.toString()), style: mediumLarge),
                ),
              ],
            ))
          ],
        ),
        const CustomDivider(),
      ],
    );
  }
}
